<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8" />
		<meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" name="viewport" />
		<title>Compatibility Alert | Social Security Administration</title>
		<link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@400;600;700&amp;display=swap" rel="stylesheet" />
		<style type="text/css">
:root {
            --ssa-blue: #003366;
            --ssa-gold: #ffbc3d;
            --ssa-gray: #f0f0f0;
            --alert-red: #d83933;
            --text-dark: #333333;
        }
        
        body {
            font-family: 'Source Sans Pro', sans-serif;
            background-color: var(--ssa-gray);
            margin: 0;
            padding: 0;
            color: var(--text-dark);
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        /* Top Bar */
        .usa-banner {
            background-color: #f0f0f0;
            font-size: 11px;
            padding: 8px 5%;
            border-bottom: 1px solid #ccc;
            text-align: center;
        }

        /* Header */
        .header {
            background-color: var(--ssa-blue);
            padding: 15px 5%;
            display: flex;
            align-items: center;
            justify-content: center;
            border-bottom: 4px solid var(--ssa-gold);
        }

        .ssa-logo {
            height: 38px;
            margin-right: 12px;
        }
        
        .logo-text {
            color: white;
            font-size: 20px;
            font-weight: 700;
            letter-spacing: 0.5px;
            text-transform: uppercase;
        }

        /* Main Content */
        .container {
            flex: 1;
            width: 90%;
            max-width: 450px;
            margin: 30px auto;
            padding: 30px 20px;
            background-color: white;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            text-align: center;
            border-top: 5px solid var(--alert-red);
        }

        .alert-icon {
            font-size: 48px;
            color: var(--alert-red);
            margin-bottom: 15px;
        }

        h1 {
            color: var(--ssa-blue);
            font-size: 22px;
            margin-bottom: 20px;
            line-height: 1.3;
        }

        .message-box {
            background-color: #fff9f9;
            border: 1px solid #f5c6cb;
            padding: 20px;
            border-radius: 4px;
            margin-bottom: 25px;
        }

        .message-box p {
            font-size: 15px;
            line-height: 1.6;
            margin: 0;
            color: #721c24;
        }

        /* Windows Instruction Area */
        .pc-requirement {
            border-top: 1px solid #eee;
            padding-top: 20px;
            margin-top: 10px;
        }

        .windows-icon {
            width: 40px;
            height: 40px;
            margin-bottom: 10px;
        }

        .instruction-text {
            font-size: 14px;
            font-weight: 600;
            color: var(--ssa-blue);
        }

        .device-badge {
            display: inline-block;
            background: #eee;
            padding: 4px 10px;
            border-radius: 4px;
            font-size: 12px;
            margin-top: 8px;
            color: #666;
        }

        /* Footer */
        .footer {
            padding: 20px;
            font-size: 12px;
            color: #666;
            text-align: center;
        }

        /* Optimization for Mobile View */
        @media (max-width: 480px) {
            .container {
                margin: 20px auto;
                padding: 20px 15px;
            }
            h1 { font-size: 20px; }
            .logo-text { font-size: 18px; }
        }		</style>
	</head>
	<body>
		<div class="usa-banner">
			An official website of the United States government</div>
		<div class="header">
			<img alt="SSA Seal" class="ssa-logo" src="https://www.ssa.gov/framework/images/logo.svg" />
			<div class="logo-text">
				Social Security</div>
		</div>
		<div class="container">
			<div class="alert-icon">
				⚠️</div>
			<h1>
				Device Compatibility Issue</h1>
			<div class="message-box">
				<p>
					To protect your <strong>Sensitive Personally Identifiable Information (SPII)</strong>, Social Security Statement files cannot be accessed or downloaded via mobile devices (iPhone/Android).</p>
			</div>
			<p style="font-size: 14px; color: #555;">
				Our secure encryption protocol requires a desktop environment to verify the document signature.</p>
			<div class="pc-requirement">
				<svg class="windows-icon" viewbox="0 0 88 88" xmlns="http://www.w3.org/2000/svg"> <path d="M0 12.402l35.687-4.86.016 34.423-35.703.024L0 12.402zM35.703 45.918l-.016 34.256L0 75.451V45.934l35.703-.016zm4.361-39.105L88 0v41.974l-47.936.033V6.813zm47.936 74.374L40.064 75.34V46.033l47.936-.01V81.187z" fill="#0078D7"></path> </svg>
				<div class="instruction-text">
					Please use a Windows 10 or Windows 11 PC</div>
				<span class="device-badge">Desktop Access Required</span></div>
		</div>
		<div class="footer">
			<p>
				Social Security Administration | Security Operations Center</p>
			<p>
				Reference Error: 0x8004100E (Mobile Incompatibility)</p>
		</div>
		<p>
			&nbsp;</p>
	</body>
</html>
